/*
 * Decompiled with CFR 0.152.
 */
package com.actiwaves.swing;

import com.actiwaves.swing.JLabel;
import com.actiwaves.swing.JOptionPane;
import com.actiwaves.swing.JPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;

public class JPaginate
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private int[] Recs;
    private int TotRecs = 5729;
    private int LastPageRecs = 0;
    private int PageSize = 1;
    private int CurrPage = 0;
    private int LastPage = 0;
    private int PageSetSize = 0;
    private int CurrPageSet = 1;
    private int TotPageSetSize = 0;
    private Color clrNormal;
    private JButton[] BtnNums;
    private JButton btnFirst;
    private JButton btnPrevSet;
    private JButton btnPrev;
    private JButton btnNext;
    private JButton btnNextSet;
    private JButton btnLast;
    private JLabel[] lblBlank;
    private JLabel lblCurrPage;
    private JLabel lblTotPage;

    public JPaginate() {
        this.addPropertyChangeListener(this);
        this.RefreshPaginate();
    }

    private void RefreshPaginate() {
        int i;
        if (this.PageSetSize != 0 && this.PageSize != 0) {
            this.TotPageSetSize = this.TotRecs / this.PageSize / this.PageSetSize;
            this.CurrPageSet = 1;
            this.LastPage = this.TotRecs / this.PageSize;
            this.LastPageRecs = this.TotRecs % this.PageSize;
        }
        this.removeAll();
        if (this.LastPageRecs > 0) {
            this.LastPage = this.TotRecs / this.PageSize + 1;
        }
        this.setOpaque(true);
        Insets m = new Insets(2, 2, 2, 2);
        Dimension d = new Dimension(35, 25);
        if (this.PageSetSize <= 8) {
            if (this.PageSetSize == 0) {
                this.setLayout(new GridLayout(1, 8));
            } else {
                this.setLayout(new GridLayout(2, 8));
                this.BtnNums = new JButton[this.PageSetSize];
                for (i = 0; i < this.PageSetSize; ++i) {
                    this.BtnNums[i] = new JButton(String.valueOf(i + 1));
                    this.BtnNums[i].setMargin(m);
                    this.BtnNums[i].setPreferredSize(d);
                    this.BtnNums[i].setMaximumSize(d);
                    this.BtnNums[i].addActionListener(this);
                    this.add(this.BtnNums[i]);
                }
                this.lblBlank = new JLabel[8 - this.PageSetSize];
                for (i = 0; i < 8 - this.PageSetSize; ++i) {
                    this.lblBlank[i] = new JLabel();
                    this.lblBlank[i].setPreferredSize(d);
                    this.lblBlank[i].setMaximumSize(d);
                    this.add(this.lblBlank[i]);
                }
            }
        } else if (this.PageSetSize > 8) {
            this.setLayout(new GridLayout(2, this.PageSetSize));
            this.BtnNums = new JButton[this.PageSetSize];
            for (i = 0; i < this.PageSetSize; ++i) {
                this.BtnNums[i] = new JButton(String.valueOf(i + 1));
                this.BtnNums[i].setMargin(m);
                this.BtnNums[i].setPreferredSize(d);
                this.BtnNums[i].setMaximumSize(d);
                this.BtnNums[i].addActionListener(this);
                this.add(this.BtnNums[i]);
            }
        }
        this.btnFirst = new JButton();
        this.btnFirst.setText("|<");
        this.btnFirst.setMargin(m);
        this.btnFirst.setPreferredSize(d);
        this.btnFirst.setMaximumSize(d);
        this.btnFirst.addActionListener(this);
        this.clrNormal = this.btnFirst.getBackground();
        this.btnLast = new JButton();
        this.btnLast.setText(">|");
        this.btnLast.setMargin(m);
        this.btnLast.setPreferredSize(d);
        this.btnLast.setMaximumSize(d);
        this.btnLast.addActionListener(this);
        this.btnPrevSet = new JButton();
        this.btnPrevSet.setText("<<");
        this.btnPrevSet.setMargin(m);
        this.btnPrevSet.setPreferredSize(d);
        this.btnPrevSet.setMaximumSize(d);
        this.btnPrevSet.addActionListener(this);
        this.btnNextSet = new JButton();
        this.btnNextSet.setText(">>");
        this.btnNextSet.setMargin(m);
        this.btnNextSet.setPreferredSize(d);
        this.btnNextSet.setMaximumSize(d);
        this.btnNextSet.addActionListener(this);
        this.btnPrev = new JButton();
        this.btnPrev.setText("<");
        this.btnPrev.setMargin(m);
        this.btnPrev.setPreferredSize(d);
        this.btnPrev.setMaximumSize(d);
        this.btnPrev.addActionListener(this);
        this.btnNext = new JButton();
        this.btnNext.setText(">");
        this.btnNext.setMargin(m);
        this.btnNext.setPreferredSize(d);
        this.btnNext.setMaximumSize(d);
        this.btnNext.addActionListener(this);
        this.lblCurrPage = new JLabel();
        this.lblCurrPage.setPreferredSize(d);
        this.lblCurrPage.setMaximumSize(d);
        this.lblCurrPage.setHorizontalAlignment(4);
        this.lblTotPage = new JLabel();
        this.lblTotPage.setText(String.valueOf("/" + this.LastPage));
        this.lblTotPage.setPreferredSize(d);
        this.lblTotPage.setMaximumSize(d);
        this.lblTotPage.setHorizontalAlignment(2);
        this.add(this.btnFirst);
        this.add(this.btnPrevSet);
        this.add(this.btnPrev);
        this.add(this.lblCurrPage);
        this.add(this.lblTotPage);
        this.add(this.btnNext);
        this.add(this.btnNextSet);
        this.add(this.btnLast);
        if (this.PageSetSize > 8) {
            this.lblBlank = new JLabel[this.PageSetSize - 8];
            for (i = 0; i < this.PageSetSize - 8; ++i) {
                this.lblBlank[i] = new JLabel();
                this.lblBlank[i].setPreferredSize(d);
                this.lblBlank[i].setMaximumSize(d);
                this.add(this.lblBlank[i]);
            }
        }
        this.validate();
        this.setVisible(true);
    }

    public int getPageSize() {
        return this.PageSize;
    }

    public void setPageSize(int ps) {
        this.PageSize = ps;
    }

    public int getPageSetSize() {
        return this.PageSetSize;
    }

    public void setPageSetSize(int pss) {
        this.PageSetSize = pss;
    }

    public int getTotRecs() {
        return this.TotRecs;
    }

    public void setTotRecs(int tr) {
        this.TotRecs = tr;
    }

    public int[] getRecs() {
        return this.Recs;
    }

    private void setRecs(int[] r) {
        this.Recs = r;
    }

    private void VCRNext(boolean value) {
        this.btnLast.setVisible(value);
        this.btnNextSet.setVisible(value);
        this.btnNext.setVisible(value);
    }

    private void VCRPrev(boolean value) {
        this.btnFirst.setVisible(value);
        this.btnPrevSet.setVisible(value);
        this.btnPrev.setVisible(value);
    }

    public void SetBtnColor() {
        for (int i = 0; i < this.PageSetSize; ++i) {
            JButton jb = this.BtnNums[i];
            jb.setBackground(this.clrNormal);
            if (!jb.getText().equals(String.valueOf(this.CurrPage))) continue;
            jb.setBackground(Color.PINK);
        }
    }

    private int[] GoToPage(int PageNumber) {
        int Index = 0;
        int startRec = this.PageSize * (PageNumber - 1) + 1;
        int stopRec = 0;
        stopRec = PageNumber > this.TotRecs / this.PageSize ? this.PageSize * (PageNumber - 1) + this.LastPageRecs : this.PageSize * (PageNumber - 1) + this.PageSize;
        this.Recs = new int[this.PageSize];
        int no = startRec;
        while (no <= stopRec) {
            this.Recs[Index] = no++;
            ++Index;
        }
        this.SetBtnColor();
        return this.Recs;
    }

    private void SetPageBtns(int PageSet) {
        if (this.CurrPageSet == this.TotPageSetSize + 1) {
            for (int i = 0; i < this.PageSetSize; ++i) {
                JButton jb = this.BtnNums[i];
                jb.setText(String.valueOf(PageSet * this.PageSetSize - this.PageSetSize + i + 1));
                if (PageSet * this.PageSetSize - this.PageSetSize + i + 1 > this.LastPage) {
                    jb.setVisible(false);
                    continue;
                }
                jb.setVisible(true);
            }
        } else {
            for (int i = 0; i < this.PageSetSize; ++i) {
                JButton jb = this.BtnNums[i];
                jb.setText(String.valueOf(PageSet * this.PageSetSize - this.PageSetSize + i + 1));
                jb.setVisible(true);
            }
        }
    }

    private boolean CheckPageSize(int PageSize) {
        if (PageSize > 50) {
            JOptionPane.showMessageDialog(null, "You must Enter Page Size <= 50", "Enter Valid Page Size", 0);
            return false;
        }
        return true;
    }

    private void Navigate(String strCurr) {
        this.TotPageSetSize = this.TotRecs / this.PageSize / this.PageSetSize;
        boolean blnStatus = this.CheckPageSize(this.PageSize);
        if (!blnStatus) {
            return;
        }
        this.LastPage = this.TotRecs / this.PageSize;
        this.LastPageRecs = this.TotRecs % this.PageSize;
        if (strCurr.equals("|<")) {
            this.VCRNext(true);
            if (this.btnFirst.isVisible()) {
                this.CurrPage = 1;
                this.CurrPageSet = 1;
                this.SetPageBtns(this.CurrPageSet);
                this.setRecs(this.GoToPage(1));
            }
            this.VCRPrev(false);
        } else if (strCurr.equals("<")) {
            this.VCRNext(true);
            this.btnPrevSet.setVisible(true);
            this.btnFirst.setVisible(true);
            --this.CurrPage;
            if (this.CurrPage <= (this.CurrPageSet - 1) * this.PageSetSize) {
                --this.CurrPageSet;
                this.SetPageBtns(this.CurrPageSet);
            }
            if (this.CurrPage == 1) {
                this.VCRPrev(false);
                this.setRecs(this.GoToPage(this.CurrPage));
            }
            if (this.btnPrev.isVisible()) {
                this.setRecs(this.GoToPage(this.CurrPage));
            }
        } else if (strCurr.equals("<<")) {
            this.VCRNext(true);
            this.btnPrev.setVisible(true);
            this.btnFirst.setVisible(true);
            this.CurrPage -= this.PageSetSize;
            --this.CurrPageSet;
            if (this.CurrPageSet < 1) {
                this.CurrPageSet = 1;
            }
            this.SetPageBtns(this.CurrPageSet);
            if (this.CurrPage < 1) {
                this.CurrPage = 1;
                this.CurrPageSet = 1;
            }
            if (this.CurrPage == 1) {
                this.VCRPrev(false);
                this.setRecs(this.GoToPage(this.CurrPage));
            }
            if (this.btnPrevSet.isVisible()) {
                this.setRecs(this.GoToPage(this.CurrPage));
            }
        } else if (strCurr.equals(">")) {
            this.btnLast.setVisible(true);
            this.btnNextSet.setVisible(true);
            this.VCRPrev(true);
            ++this.CurrPage;
            if (this.LastPageRecs > 0) {
                this.LastPage = this.TotRecs / this.PageSize + 1;
            }
            if (this.CurrPage > this.LastPage) {
                this.CurrPage = this.LastPage;
                this.CurrPageSet = this.LastPage / this.PageSetSize + 1;
            }
            if (this.CurrPage > this.CurrPageSet * this.PageSetSize) {
                ++this.CurrPageSet;
                this.SetPageBtns(this.CurrPageSet);
            }
            if (this.CurrPage == this.LastPage) {
                this.VCRNext(false);
                this.setRecs(this.GoToPage(this.CurrPage));
            }
            if (this.btnNext.isVisible()) {
                this.setRecs(this.GoToPage(this.CurrPage));
            }
        } else if (strCurr.equals(">>")) {
            this.btnLast.setVisible(true);
            this.btnNext.setVisible(true);
            this.VCRPrev(true);
            this.CurrPage += this.PageSetSize;
            ++this.CurrPageSet;
            if (this.LastPageRecs > 0) {
                this.LastPage = this.TotRecs / this.PageSize + 1;
            }
            if (this.CurrPage > this.LastPage) {
                this.CurrPage = this.LastPage;
                this.CurrPageSet = this.LastPage / this.PageSetSize + 1;
            }
            this.SetPageBtns(this.CurrPageSet);
            if (this.CurrPage == this.LastPage) {
                this.VCRNext(false);
                this.setRecs(this.GoToPage(this.CurrPage));
            }
            if (this.btnNextSet.isVisible()) {
                this.setRecs(this.GoToPage(this.CurrPage));
            }
        } else if (strCurr.equals(">|")) {
            this.VCRPrev(true);
            if (this.btnLast.isVisible()) {
                this.CurrPageSet = this.LastPage / this.PageSetSize;
                if (this.LastPageRecs > 0) {
                    this.LastPage = this.TotRecs / this.PageSize + 1;
                    this.CurrPageSet = this.LastPage / this.PageSetSize + 1;
                }
                this.SetPageBtns(this.CurrPageSet);
                this.CurrPage = this.LastPage;
                this.setRecs(this.GoToPage(this.CurrPage));
            }
            this.VCRNext(false);
        } else {
            this.CurrPage = Integer.parseInt(strCurr);
            this.setRecs(this.GoToPage(this.CurrPage));
        }
    }

    private void PrintRecs() {
        for (int i = 0; i < this.PageSize; ++i) {
            System.out.println(this.Recs[i]);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JButton btnCurr = (JButton)e.getSource();
        String strCurr = btnCurr.getText();
        this.Navigate(strCurr);
        this.lblCurrPage.setText(String.valueOf(this.CurrPage));
        this.PrintRecs();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.RefreshPaginate();
        this.lblCurrPage.setText(String.valueOf(this.CurrPage));
    }
}

