/*
 * Decompiled with CFR 0.152.
 */
package com.actiwaves.swing.TestSwing;

import com.actiwaves.swing.TestSwing.States;
import com.actiwaves.swing.TestSwing.TestSwingApp;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class StatesForm
extends JPanel {
    private JTextField countryCodeField;
    private JLabel countryCodeLabel;
    private JButton deleteButton;
    private EntityManager entityManager;
    private List<States> list;
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private JButton newButton;
    private Query query;
    private JButton refreshButton;
    private JButton saveButton;
    private JTextField stateIDField;
    private JLabel stateIDLabel;
    private JTextField stateNameField;
    private JLabel stateNameLabel;
    private BindingGroup bindingGroup;

    public StatesForm() {
        this.initComponents();
        TableSelectionListener listener = new TableSelectionListener();
        this.masterTable.getSelectionModel().addListSelectionListener(listener);
        this.entityManager.getTransaction().begin();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.entityManager = Persistence.createEntityManagerFactory((String)"testswingPU").createEntityManager();
        ResourceMap resourceMap = Application.getInstance(TestSwingApp.class).getContext().getResourceMap(StatesForm.class);
        this.query = this.entityManager.createQuery(resourceMap.getString("query.query", new Object[0]));
        this.list = ObservableCollections.observableList((List)this.query.getResultList());
        this.masterScrollPane = new JScrollPane();
        this.masterTable = new JTable();
        this.stateIDLabel = new JLabel();
        this.stateNameLabel = new JLabel();
        this.countryCodeLabel = new JLabel();
        this.stateIDField = new JTextField();
        this.stateNameField = new JTextField();
        this.countryCodeField = new JTextField();
        this.saveButton = new JButton();
        this.refreshButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        FormListener formListener = new FormListener();
        this.setName("Form");
        this.masterScrollPane.setName("masterScrollPane");
        this.masterTable.setName("masterTable");
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.list, (JTable)this.masterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)"${stateID}"));
        columnBinding.setColumnName("State ID");
        columnBinding.setColumnClass(Short.class);
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)"${stateName}"));
        columnBinding.setColumnName("State Name");
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding((Property)ELProperty.create((String)"${countryCode}"));
        columnBinding.setColumnName("Country Code");
        columnBinding.setColumnClass(Short.class);
        this.bindingGroup.addBinding((Binding)jTableBinding);
        this.masterScrollPane.setViewportView(this.masterTable);
        this.stateIDLabel.setText(resourceMap.getString("stateIDLabel.text", new Object[0]));
        this.stateIDLabel.setName("stateIDLabel");
        this.stateNameLabel.setText(resourceMap.getString("stateNameLabel.text", new Object[0]));
        this.stateNameLabel.setName("stateNameLabel");
        this.countryCodeLabel.setText(resourceMap.getString("countryCodeLabel.text", new Object[0]));
        this.countryCodeLabel.setName("countryCodeLabel");
        this.stateIDField.setName("stateIDField");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.masterTable, (Property)ELProperty.create((String)"${selectedElement.stateID}"), (Object)this.stateIDField, (Property)BeanProperty.create((String)"text"));
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.masterTable, (Property)ELProperty.create((String)"${selectedElement != null}"), (Object)this.stateIDField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.stateNameField.setName("stateNameField");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.masterTable, (Property)ELProperty.create((String)"${selectedElement.stateName}"), (Object)this.stateNameField, (Property)BeanProperty.create((String)"text"));
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.masterTable, (Property)ELProperty.create((String)"${selectedElement != null}"), (Object)this.stateNameField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.countryCodeField.setName("countryCodeField");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.masterTable, (Property)ELProperty.create((String)"${selectedElement.countryCode}"), (Object)this.countryCodeField, (Property)BeanProperty.create((String)"text"));
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.masterTable, (Property)ELProperty.create((String)"${selectedElement != null}"), (Object)this.countryCodeField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.saveButton.setText(resourceMap.getString("saveButton.text", new Object[0]));
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(formListener);
        this.refreshButton.setText(resourceMap.getString("refreshButton.text", new Object[0]));
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(formListener);
        this.newButton.setText(resourceMap.getString("newButton.text", new Object[0]));
        this.newButton.setName("newButton");
        this.newButton.addActionListener(formListener);
        this.deleteButton.setText(resourceMap.getString("deleteButton.text", new Object[0]));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setName("deleteButton");
        this.deleteButton.addActionListener(formListener);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.newButton).addPreferredGap(0).add((Component)this.deleteButton).addPreferredGap(0).add((Component)this.refreshButton).addPreferredGap(0).add((Component)this.saveButton).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.stateIDLabel).add((Component)this.stateNameLabel).add((Component)this.countryCodeLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.stateIDField, -1, 315, Short.MAX_VALUE).add((Component)this.stateNameField, -1, 315, Short.MAX_VALUE).add((Component)this.countryCodeField, -1, 315, Short.MAX_VALUE)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.masterScrollPane, -1, 380, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(new Component[]{this.deleteButton, this.newButton, this.refreshButton, this.saveButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.masterScrollPane, -1, 130, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.stateIDLabel).add((Component)this.stateIDField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.stateNameLabel).add((Component)this.stateNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.countryCodeLabel).add((Component)this.countryCodeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.saveButton).add((Component)this.refreshButton).add((Component)this.deleteButton).add((Component)this.newButton)).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        this.list.clear();
        this.list.addAll(this.query.getResultList());
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int[] selected = this.masterTable.getSelectedRows();
        ArrayList<States> toRemove = new ArrayList<States>(selected.length);
        for (int idx = 0; idx < selected.length; ++idx) {
            States s = this.list.get(selected[idx]);
            toRemove.add(s);
            this.entityManager.remove((Object)s);
        }
        this.list.removeAll(toRemove);
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        States s = new States();
        this.entityManager.persist((Object)s);
        this.list.add(s);
        int row = this.list.size() - 1;
        this.masterTable.setRowSelectionInterval(row, row);
        this.masterTable.scrollRectToVisible(this.masterTable.getCellRect(row, 0, true));
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame();
                frame.setContentPane(new StatesForm());
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == StatesForm.this.masterTable.getSelectionModel()) {
                boolean enabled = StatesForm.this.masterTable.getSelectedRow() != -1;
                StatesForm.this.deleteButton.setEnabled(enabled);
            }
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == StatesForm.this.saveButton) {
                StatesForm.this.saveButtonActionPerformed(evt);
            } else if (evt.getSource() == StatesForm.this.refreshButton) {
                StatesForm.this.refreshButtonActionPerformed(evt);
            } else if (evt.getSource() == StatesForm.this.newButton) {
                StatesForm.this.newButtonActionPerformed(evt);
            } else if (evt.getSource() == StatesForm.this.deleteButton) {
                StatesForm.this.deleteButtonActionPerformed(evt);
            }
        }
    }
}

