/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.actiwaves.swing.TestSwing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 *
 * @author sudeep.panchal
 */
@Entity
@Table(name = "cities")
@NamedQueries( {@NamedQuery(name = "Cities.findByCityCode",query = "SELECT c FROM Cities c WHERE c.cityCode = :cityCode"),@NamedQuery(name = "Cities.findByCityName",query = "SELECT c FROM Cities c WHERE c.cityName = :cityName"),@NamedQuery(name = "Cities.findByDistrict",query = "SELECT c FROM Cities c WHERE c.district = :district"),@NamedQuery(name = "Cities.findByStateID",query = "SELECT c FROM Cities c WHERE c.stateID = :stateID")})
public class Cities implements Serializable {
    @Transient
    private
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final
    long serialVersionUID = 1L;
    @Id
    @Column(name = "CityCode",nullable = false)
    private
    Long cityCode;
    @Column(name = "CityName",nullable = false)
    private
    String cityName;
    @Column(name = "District",nullable = false)
    private
    String district;
    @Column(name = "StateID",nullable = false)
    private
    long stateID;

    public
    Cities()
    {
    }

    public
    Cities(Long cityCode)
    {
        this.cityCode = cityCode;
    }

    public
    Cities(Long cityCode,String cityName,String district,long stateID)
    {
        this.cityCode = cityCode;
        this.cityName = cityName;
        this.district = district;
        this.stateID = stateID;
    }

    public
    Long getCityCode()
    {
        return cityCode;
    }

    public
    void setCityCode(Long cityCode)
    {
        Long oldCityCode = this.cityCode;
        this.cityCode = cityCode;
        changeSupport.firePropertyChange("cityCode",oldCityCode,cityCode);
    }

    public
    String getCityName()
    {
        return cityName;
    }

    public
    void setCityName(String cityName)
    {
        String oldCityName = this.cityName;
        this.cityName = cityName;
        changeSupport.firePropertyChange("cityName",oldCityName,cityName);
    }

    public
    String getDistrict()
    {
        return district;
    }

    public
    void setDistrict(String district)
    {
        String oldDistrict = this.district;
        this.district = district;
        changeSupport.firePropertyChange("district",oldDistrict,district);
    }

    public
    long getStateID()
    {
        return stateID;
    }

    public
    void setStateID(long stateID)
    {
        long oldStateID = this.stateID;
        this.stateID = stateID;
        changeSupport.firePropertyChange("stateID",oldStateID,stateID);
    }

    @Override
    public
    int hashCode()
    {
        int hash = 0;
        hash += (cityCode != null ? cityCode.hashCode() : 0);
        return hash;
    }

    @Override
    public
    boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if(!(object instanceof Cities))
        {
            return false;
        }
        Cities other = (Cities)object;
        if((this.cityCode == null && other.cityCode != null) || (this.cityCode != null && !this.cityCode.equals(other.cityCode)))
        {
            return false;
        }
        return true;
    }

    @Override
    public
    String toString()
    {
        return "com.actiwaves.swing.TestSwing.Cities[cityCode=" + cityCode + "]";
    }

    public
    void addPropertyChangeListener(PropertyChangeListener listener)
    {
        changeSupport.addPropertyChangeListener(listener);
    }

    public
    void removePropertyChangeListener(PropertyChangeListener listener)
    {
        changeSupport.addPropertyChangeListener(listener);
    }

}
