/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.actiwaves.swing.TestSwing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 *
 * @author sudeep.panchal
 */
@Entity
@Table(name = "countries")
@NamedQueries( {@NamedQuery(name = "Countries.findByCountryCode",query = "SELECT c FROM Countries c WHERE c.countryCode = :countryCode"),@NamedQuery(name = "Countries.findByCountryName",query = "SELECT c FROM Countries c WHERE c.countryName = :countryName")})
public class Countries implements Serializable {
    @Transient
    private
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final
    long serialVersionUID = 1L;
    @Id
    @Column(name = "CountryCode",nullable = false)
    private
    Short countryCode;
    @Column(name = "CountryName",nullable = false)
    private
    String countryName;

    public
    Countries()
    {
    }

    public
    Countries(Short countryCode)
    {
        this.countryCode = countryCode;
    }

    public
    Countries(Short countryCode,String countryName)
    {
        this.countryCode = countryCode;
        this.countryName = countryName;
    }

    public
    Short getCountryCode()
    {
        return countryCode;
    }

    public
    void setCountryCode(Short countryCode)
    {
        Short oldCountryCode = this.countryCode;
        this.countryCode = countryCode;
        changeSupport.firePropertyChange("countryCode",oldCountryCode,countryCode);
    }

    public
    String getCountryName()
    {
        return countryName;
    }

    public
    void setCountryName(String countryName)
    {
        String oldCountryName = this.countryName;
        this.countryName = countryName;
        changeSupport.firePropertyChange("countryName",oldCountryName,countryName);
    }

    @Override
    public
    int hashCode()
    {
        int hash = 0;
        hash += (countryCode != null ? countryCode.hashCode() : 0);
        return hash;
    }

    @Override
    public
    boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if(!(object instanceof Countries))
        {
            return false;
        }
        Countries other = (Countries)object;
        if((this.countryCode == null && other.countryCode != null) || (this.countryCode != null && !this.countryCode.equals(other.countryCode)))
        {
            return false;
        }
        return true;
    }

    @Override
    public
    String toString()
    {
        return "com.actiwaves.swing.TestSwing.Countries[countryCode=" + countryCode + "]";
    }

    public
    void addPropertyChangeListener(PropertyChangeListener listener)
    {
        changeSupport.addPropertyChangeListener(listener);
    }

    public
    void removePropertyChangeListener(PropertyChangeListener listener)
    {
        changeSupport.addPropertyChangeListener(listener);
    }

}
