/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.actiwaves.swing;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.*;
import java.math.*;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;

/**
 *
 * @author Deepa.kanchal
 */
public class JLabelComboBox extends javax.swing.JPanel
{
    private JLabel lblLabel;
    private JComboBox cbComboBox;
    private int _ComponentGap = 1,  _LabelWidth = 1,  _ComboWidth = 1;
    private String _LabelPosition = "LEFT",  _LabelAlignment = "LEFT";
    private Dimension dim;
    private GroupLayout layoutGroup;
    private ComboBoxModel cbModel;

    public JLabelComboBox()
    {
        lblLabel = new JLabel();
        lblLabel.setText("jlabelcombobox1");
        _LabelWidth = lblLabel.getPreferredSize().width;

        cbComboBox = new JComboBox();
        dim = new Dimension(45,19);
        cbComboBox.setPreferredSize(dim);
        _ComboWidth = cbComboBox.getPreferredSize().width;

        layoutGroup = new GroupLayout(this);
        RefreshLayout();

        validate();
    }

    public void RefreshLayout()
    {
        this.setLayout(layoutGroup);

        if(_LabelPosition.equals("LEFT"))
        {
            layoutGroup.setHorizontalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(lblLabel,_LabelWidth,_LabelWidth,_LabelWidth).add(_ComponentGap,_ComponentGap,_ComponentGap).add(cbComboBox,_ComboWidth,_ComboWidth,_ComboWidth)));
            layoutGroup.setVerticalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(lblLabel).add(cbComboBox)));
        }
        else if(_LabelPosition.equals("RIGHT"))
        {
            layoutGroup.setHorizontalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(cbComboBox,_ComboWidth,_ComboWidth,_ComboWidth).add(_ComponentGap,_ComponentGap,_ComponentGap).add(lblLabel,_LabelWidth,_LabelWidth,_LabelWidth)));
            layoutGroup.setVerticalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(cbComboBox).add(lblLabel)));
        }
        else if(_LabelPosition.equals("TOP"))
        {
            layoutGroup.setHorizontalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(layoutGroup.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(lblLabel,_LabelWidth,_LabelWidth,_LabelWidth).add(cbComboBox,_ComboWidth,_ComboWidth,_ComboWidth))));
            layoutGroup.setVerticalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(lblLabel).add(_ComponentGap,_ComponentGap,_ComponentGap).add(cbComboBox)));
        }
        else if(_LabelPosition.equals("BOTTOM"))
        {
            layoutGroup.setHorizontalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(layoutGroup.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(cbComboBox,_ComboWidth,_ComboWidth,_ComboWidth).add(lblLabel,_LabelWidth,_LabelWidth,_LabelWidth))));
            layoutGroup.setVerticalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(cbComboBox).add(_ComponentGap,_ComponentGap,_ComponentGap).add(lblLabel)));
        }
    }

    public String getComboText()
    {
        return cbComboBox.getSelectedItem().toString();
    }

    public void setComboText(String combo)
    {
        cbComboBox.setSelectedItem(combo);
        _ComboWidth = cbComboBox.getPreferredSize().width;
        RefreshLayout();
    }

    /**
     * Get the Text of Label..
     * @return
     */
    public String getLabelText()
    {
        return lblLabel.getText();
    }

    /**
     * Set the Text & Width of Label &
     * call RefreshLayout with given _LabelWidth
     * @param label
     */
    public void setLabelText(String label)
    {
        lblLabel.setText(label);
        _LabelWidth = lblLabel.getPreferredSize().width;
        RefreshLayout();
    }

    /**
     * Get the Width of ComboBox..
     * @return
     */
    public int getComboWidth()
    {
        return cbComboBox.getPreferredSize().width;
    }

    /**
     * Set the Width of ComboBox..
     * @param cbLen
     */
    public void setComboWidth(int cbLen)
    {
        _ComboWidth = cbLen;

        dim = new Dimension(getPreferredSize().width - lblLabel.getPreferredSize().width,cbComboBox.getPreferredSize().height);
        cbComboBox.setPreferredSize(dim);
        RefreshLayout();
    }

    /**
     * Get the Width of Label..
     * @return
     */
    public int getLabelWidth()
    {
        return lblLabel.getPreferredSize().width;
    }

    /**
     * Set the Width of Label..
     * @param lblLen
     */
    public void setLabelWidth(int lblLen)
    {
        _LabelWidth = lblLen;

        dim = new Dimension(lblLen,lblLabel.getPreferredSize().height);
        lblLabel.setPreferredSize(dim);
        RefreshLayout();
    }

    /**
     * Get the Current Position (LEFT/RIGHT/TOP/BOTTOM) of Label with response to TextBox..
     * @return
     */
    public String getLabelPosition()
    {
        return this._LabelPosition;
    }

    /**
     * Set the Position (LEFT/RIGHT/TOP/BOTTOM) of Label with response to TextBox..
     * @param pos
     */
    public void setLabelPosition(String pos)
    {
        this._LabelPosition = pos;
        RefreshLayout();
    }

    /**
     * Get the Current Alignment of Label..
     * @return
     */
    public String getLabelAlignment()
    {
        return this._LabelAlignment;
    }

    /**
     * Set the Alignment (LEFT/RIGHT/CENTER) of Label..
     * @param align
     */
    public void setLabelAlignment(String align)
    {
        this._LabelAlignment = align;

        if(_LabelAlignment.equals("LEFT"))
        {
            lblLabel.setHorizontalAlignment(2);
        }
        else if(_LabelAlignment.equals("RIGHT"))
        {
            lblLabel.setHorizontalAlignment(4);
        }
        else if(_LabelAlignment.equals("CENTER"))
        {
            lblLabel.setHorizontalAlignment(0);
        }
    }

    /**
     * Get the Gap between Label & TextBox..
     * @return
     */
    public int getComponentGap()
    {
        return this._ComponentGap;
    }

    /**
     * Set the Gap between Label & TextBox..
     * @param gap
     */
    public void setComponentGap(int gap)
    {
        this._ComponentGap = gap;
        RefreshLayout();
    }

    /*
     * old code before RefreshLayout..
     */
    
//    public void RefreshJLabelComboBox()
//    {
//        this.removeAll();
//
//        lblLabel = new JLabel();
//        lblLabel.setText(Label);
//        dim = new Dimension((lblLabel.getText().length() * 5) + (_LabelWidth * 5),14);
//        lblLabel.setPreferredSize(dim);
//        lblLabel.setMaximumSize(dim);
//
//        cbComboBox = new JComboBox();
//        dim = new Dimension(41,19);
//        cbComboBox.setPreferredSize(dim);
//
//        if(_LabelPosition.equals("LEFT"))
//        {
//            setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
////            setLayout(new GridLayout(1, 2));
//
//            add(lblLabel);
//            add(cbComboBox);
//        }
//        else if(_LabelPosition.equals("RIGHT"))
//        {
//            setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
////            setLayout(new GridLayout(1, 2));
//
//            add(cbComboBox);
//            add(lblLabel);
//        }
//        else if(_LabelPosition.equals("TOP"))
//        {
////            setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
//            setLayout(new GridLayout(2, 1));
//
//            add(lblLabel);
//            add(cbComboBox);
//        }
//        else if(_LabelPosition.equals("BOTTOM"))
//        {
////            setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
//            setLayout(new GridLayout(2, 1));
//
//            add(cbComboBox);
//            add(lblLabel);
//        }
//        
//        if(_LabelAlignment.equals("LEFT"))
//        {
//            lblLabel.setHorizontalAlignment(2);
//        }
//        else if(_LabelAlignment.equals("RIGHT"))
//        {
//            lblLabel.setHorizontalAlignment(4);
//        }
//        else if(_LabelAlignment.equals("CENTER"))
//        {
//            lblLabel.setHorizontalAlignment(0);
//        }
//
//        validate();
//    }
//
//    public String getLabel()
//    {
//        return this.Label;
//    }
//
//    public void setLabel(String label)
//    {
//        this.Label = label;
//    }
//
//    public int getLabelLength()
//    {
//        return this._LabelWidth;
//    }
//
//    public void setLabelLength(int len)
//    {
//        this._LabelWidth = len;
//    }
//
//    public String getLabelPosition()
//    {
//        return this._LabelPosition;
//    }
//    
//    public void setLabelPosition(String pos)
//    {
//        this._LabelPosition = pos;
//    }
//    
//    public String getLabelAlignment()
//    {
//        return this._LabelAlignment;
//    }
//    
//    public void setLabelAlignment(String align)
//    {
//        this._LabelAlignment = align;
//    }
//    
//    public void propertyChange(PropertyChangeEvent evt)
//    {
//        RefreshJLabelComboBox();
//    }
}
