/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.actiwaves.swing;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import org.jdesktop.layout.GroupLayout;

/**
 *
 * @author sudeep.panchal
 */
public class JLabelList extends JPanel implements PropertyChangeListener
{
    JLabel lbl;
    JList lst;
    int LabelLength = 1;
    String Label = "jlabellist1", LabelPosition = "LEFT", LabelAlignment = "LEFT";
    Dimension dim;

    public JLabelList()
    {
        RefreshJLabelSpinner();

        addPropertyChangeListener(this);
    }

    private void RefreshJLabelSpinner()
    {
        this.removeAll();

        lbl = new JLabel();
        lbl.setText(Label);
        dim = new Dimension((lbl.getText().length() * 5) + (LabelLength * 5),14);
        lbl.setPreferredSize(dim);
        lbl.setMaximumSize(dim);

        lst = new JList();
        dim = new Dimension(33,80);
        lst.setPreferredSize(dim);

        if(LabelPosition.equals("LEFT"))
        {
//            setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
            setLayout(new GridLayout(1, 2));
            lbl.setVerticalAlignment(1);

            add(lbl);
            add(lst);
        }
        else if(LabelPosition.equals("RIGHT"))
        {
//            setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
            setLayout(new GridLayout(1, 2));
            lbl.setVerticalAlignment(1);

            add(lst);
            add(lbl);
        }
        else if(LabelPosition.equals("TOP"))
        {
            setLayout(new GridLayout(2,1));
            lbl.setVerticalAlignment(3);

            add(lbl);
            add(lst);
        }
        else if(LabelPosition.equals("BOTTOM"))
        {
            setLayout(new GridLayout(2,1));
            lbl.setVerticalAlignment(1);

            add(lst);
            add(lbl);
        }

        if(LabelAlignment.equals("LEFT"))
        {
            lbl.setHorizontalAlignment(2);
        }
        if(LabelAlignment.equals("RIGHT"))
        {
            lbl.setHorizontalAlignment(4);
        }
        if(LabelAlignment.equals("CENTER"))
        {
            lbl.setHorizontalAlignment(0);
        }
    }

    public String getLabel()
    {
        return this.Label;
    }

    public void setLabel(String label)
    {
        this.Label = label;
    }

    public int getLabelLength()
    {
        return this.LabelLength;
    }

    public void setLabelLength(int len)
    {
        this.LabelLength = len;
    }

    public String getLabelPosition()
    {
        return this.LabelPosition;
    }

    public void setLabelPosition(String pos)
    {
        this.LabelPosition = pos;
    }

    public String getLabelAlignment()
    {
        return this.LabelAlignment;
    }

    public void setLabelAlignment(String align)
    {
        this.LabelAlignment = align;
    }

    public void propertyChange(PropertyChangeEvent evt)
    {
        RefreshJLabelSpinner();
    }

}
