/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.actiwaves.swing;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;

/**
 *
 * @author sudeep.panchal
 */
public class JLabelSpinner extends JPanel implements PropertyChangeListener
{
    JLabel lbl;
    JSpinner spnr;
    int LabelLength = 1;
    String Label = "jlabelspinner1", LabelPosition = "LEFT", LabelAlignment = "LEFT";
    Dimension dim;

    public JLabelSpinner()
    {
        RefreshJLabelSpinner();

        addPropertyChangeListener(this);
    }

    private void RefreshJLabelSpinner()
    {
        this.removeAll();

        lbl = new JLabel();
        lbl.setText(Label);
        dim = new Dimension((lbl.getText().length() * 5) + (LabelLength * 5),14);
        lbl.setPreferredSize(dim);
        lbl.setMaximumSize(dim);

        spnr = new JSpinner();
        dim = new Dimension(41,19);
        spnr.setPreferredSize(dim);

        if(LabelPosition.equals("LEFT"))
        {
            setLayout(new BoxLayout(this,BoxLayout.X_AXIS));

            add(lbl);
            add(spnr);
        }
        else if(LabelPosition.equals("RIGHT"))
        {
            setLayout(new BoxLayout(this,BoxLayout.X_AXIS));

            add(spnr);
            add(lbl);
        }
        else if(LabelPosition.equals("TOP"))
        {
            setLayout(new GridLayout(2,1));

            add(lbl);
            add(spnr);
        }
        else if(LabelPosition.equals("BOTTOM"))
        {
            setLayout(new GridLayout(2,1));

            add(spnr);
            add(lbl);
        }
        
        if(LabelAlignment.equals("LEFT"))
        {
            lbl.setHorizontalAlignment(2);
        }
        if(LabelAlignment.equals("RIGHT"))
        {
            lbl.setHorizontalAlignment(4);
        }
        if(LabelAlignment.equals("CENTER"))
        {
            lbl.setHorizontalAlignment(0);
        }
    }

    public String getLabel()
    {
        return this.Label;
    }

    public void setLabel(String label)
    {
        this.Label = label;
    }

    public int getLabelLength()
    {
        return this.LabelLength;
    }

    public void setLabelLength(int len)
    {
        this.LabelLength = len;
    }

    public String getLabelPosition()
    {
        return this.LabelPosition;
    }

    public void setLabelPosition(String pos)
    {
        this.LabelPosition = pos;
    }

    public String getLabelAlignment()
    {
        return this.LabelAlignment;
    }

    public void setLabelAlignment(String align)
    {
        this.LabelAlignment = align;
    }

    public void propertyChange(PropertyChangeEvent evt)
    {
        RefreshJLabelSpinner();
    }

}
