/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.actiwaves.swing;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.*;
import java.math.*;
import org.jdesktop.layout.GroupLayout;

/**
 *
 * @author sudeep.panchal
 */
public class JLabelTextBox extends javax.swing.JPanel
{
    private JLabel lblLabel;
    private JTextField txtTextField;
    private int _ComponentGap = 1,  _LabelWidth = 1,  _TextWidth = 1;
    private String _LabelPosition = "LEFT",  _LabelAlignment = "LEFT";
    private boolean _TextEditable = false;
    private Dimension dim;
    private GroupLayout layoutGroup;

    /**
     * Main Constructor to Create New Label & TextField,
     * Set the Layout of Panel & then add Label & TextField
     * to the Panel..
     */
    public JLabelTextBox()
    {
        lblLabel = new JLabel();
        lblLabel.setText("jlabeltextbox1");
        _LabelWidth = lblLabel.getPreferredSize().width;

        txtTextField = new JTextField();
        txtTextField.setText("");
        dim = new Dimension(70,19);
        txtTextField.setPreferredSize(dim);
        _TextWidth = txtTextField.getPreferredSize().width;
        txtTextField.setEditable(_TextEditable);
        
        /*
         * Old Code Before RefreshLayout()..
         */

//        setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
//        add(lblLabel);
//        add(txtTextField);

        layoutGroup = new GroupLayout(this);
        RefreshLayout();

        validate();
    }

    /**
     * Redraw the Layout according to the _LabelPosition &
     * add the Gap between Label and TextField according to
     * the _ComponentGap. Also add required Width to Label &
     * TextField according to _LabelWidth & _TextWidth resp..
     */
    public void RefreshLayout()
    {
        this.setLayout(layoutGroup);

        if(_LabelPosition.equals("LEFT"))
        {
            layoutGroup.setHorizontalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(lblLabel,_LabelWidth,_LabelWidth,_LabelWidth).add(_ComponentGap,_ComponentGap,_ComponentGap).add(txtTextField,_TextWidth,_TextWidth,_TextWidth)));
            layoutGroup.setVerticalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(lblLabel).add(txtTextField)));
        }
        else if(_LabelPosition.equals("RIGHT"))
        {
            layoutGroup.setHorizontalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(txtTextField,_TextWidth,_TextWidth,_TextWidth).add(_ComponentGap,_ComponentGap,_ComponentGap).add(lblLabel,_LabelWidth,_LabelWidth,_LabelWidth)));
            layoutGroup.setVerticalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(txtTextField).add(lblLabel)));
        }
        else if(_LabelPosition.equals("TOP"))
        {
            layoutGroup.setHorizontalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(layoutGroup.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(lblLabel).add(txtTextField))));
            layoutGroup.setVerticalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(lblLabel,_LabelWidth,_LabelWidth,_LabelWidth).add(_ComponentGap,_ComponentGap,_ComponentGap).add(txtTextField,_TextWidth,_TextWidth,_TextWidth)));
        }
        else if(_LabelPosition.equals("BOTTOM"))
        {
            layoutGroup.setHorizontalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(layoutGroup.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(txtTextField).add(lblLabel))));
            layoutGroup.setVerticalGroup(
                layoutGroup.createParallelGroup(GroupLayout.LEADING).add(layoutGroup.createSequentialGroup().add(txtTextField,_TextWidth,_TextWidth,_TextWidth).add(_ComponentGap,_ComponentGap,_ComponentGap).add(lblLabel,_LabelWidth,_LabelWidth,_LabelWidth)));
        }
    }

    /**
     * Get the Text of TextField..
     * @return
     */
    public String getTextFieldText()
    {
        return txtTextField.getText();
    }

    /**
     * Set the Text & Width of TextField &
     * call RefreshLayout with given _TextWidth
     * @param text
     */
    public void setTextFieldText(String text)
    {
        txtTextField.setText(text);
        _TextWidth = txtTextField.getPreferredSize().width;
        RefreshLayout();
    }

    /**
     * Get the Text of Label..
     * @return
     */
    public String getLabelText()
    {
        return lblLabel.getText();
    }

    /**
     * Set the Text & Width of Label &
     * call RefreshLayout with given _LabelWidth
     * @param label
     */
    public void setLabelText(String label)
    {
        lblLabel.setText(label);
        _LabelWidth = lblLabel.getPreferredSize().width;
        RefreshLayout();
    }

    /**
     * Get the Width of TextField..
     * @return
     */
    public int getTextFieldWidth()
    {
        return txtTextField.getPreferredSize().width;
    }

    /**
     * Set the Width of TextField..
     * @param txtLen
     */
    public void setTextFieldWidth(int txtLen)
    {
        _TextWidth = txtLen;

        dim = new Dimension(getPreferredSize().width - lblLabel.getPreferredSize().width,txtTextField.getPreferredSize().height);
        txtTextField.setPreferredSize(dim);
        RefreshLayout();
    }

    /**
     * Get the Width of Label..
     * @return
     */
    public int getLabelWidth()
    {
        return lblLabel.getPreferredSize().width;
    }

    /**
     * Set the Width of Label..
     * @param lblLen
     */
    public void setLabelWidth(int lblLen)
    {
        _LabelWidth = lblLen;

        dim = new Dimension(lblLen,lblLabel.getPreferredSize().height);
        lblLabel.setPreferredSize(dim);
        RefreshLayout();
    }

    /**
     * Get the Current Position (LEFT/RIGHT/TOP/BOTTOM) of Label with response to TextBox..
     * @return
     */
    public String getLabelPosition()
    {
        return this._LabelPosition;
    }

    /**
     * Set the Position (LEFT/RIGHT/TOP/BOTTOM) of Label with response to TextBox..
     * @param pos
     */
    public void setLabelPosition(String pos)
    {
        this._LabelPosition = pos;
        RefreshLayout();

    /*
     *  Old Code before making RefreshLayout().. 
     */

//        if(_LabelPosition.equals("LEFT"))
//        {
//            setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
//
//            remove(txtTextField);
//            add(txtTextField);
//        }
//        if(_LabelPosition.equals("RIGHT"))
//        {
//            setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
//
//            remove(lblLabel);
//            add(lblLabel);
//        }
//        if(_LabelPosition.equals("TOP"))
//        {
//            setLayout(new GridLayout(2,1));
//
//            remove(txtTextField);
//            add(txtTextField);
//        }
//        if(_LabelPosition.equals("BOTTOM"))
//        {
//            setLayout(new GridLayout(2,1));
//
//            remove(lblLabel);
//            add(lblLabel);
//        }

    }

    /**
     * Get the Current Alignment of Label..
     * @return
     */
    public String getLabelAlignment()
    {
        return this._LabelAlignment;
    }

    /**
     * Set the Alignment (LEFT/RIGHT/CENTER) of Label..
     * @param align
     */
    public void setLabelAlignment(String align)
    {
        this._LabelAlignment = align;

        if(_LabelAlignment.equals("LEFT"))
        {
            lblLabel.setHorizontalAlignment(2);
        }
        else if(_LabelAlignment.equals("RIGHT"))
        {
            lblLabel.setHorizontalAlignment(4);
        }
        else if(_LabelAlignment.equals("CENTER"))
        {
            lblLabel.setHorizontalAlignment(0);
        }
    }

    /**
     * Get the Gap between Label & TextBox..
     * @return
     */
    public int getComponentGap()
    {
        return this._ComponentGap;
    }

    /**
     * Set the Gap between Label & TextBox..
     * @param gap
     */
    public void setComponentGap(int gap)
    {
        this._ComponentGap = gap;
        RefreshLayout();
    }

    public boolean getTextEditable()
    {
//        return txtTextField.isEditable();
        return this._TextEditable;
    }

    public void setTextEditable(boolean edit)
    {
        this._TextEditable = edit;

        if(_TextEditable == true)
        {
            txtTextField.setEditable(true);
        }
        else if(_TextEditable == false)
        {
            txtTextField.setEditable(false);
        }
    }

}
