/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.actiwaves.swing;

import javax.swing.JButton;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 *
 * @author sudeep.panchal
 */
public class JPaginate extends JPanel implements ActionListener,
                                                  PropertyChangeListener
{
    private int Recs[],  TotRecs = 5729,  LastPageRecs = 0;
    private int PageSize = 1,  CurrPage = 0,  LastPage = 0;
    private int PageSetSize = 0,  CurrPageSet = 1,  TotPageSetSize = 0;
    private Color clrNormal;
    private JButton BtnNums[],  btnFirst,  btnPrevSet,  btnPrev,  btnNext,  btnNextSet,  btnLast;
    private JLabel lblBlank[],  lblCurrPage,  lblTotPage;

    /**
     * Main Constructor..
     */
    public JPaginate()
    {
        addPropertyChangeListener(this);

        RefreshPaginate();
    }

    /**
     * Create the Component using the Buttons as required..
     */
    private void RefreshPaginate()
    {
        if(PageSetSize != 0 && PageSize != 0)
        {
            TotPageSetSize = (TotRecs / PageSize) / PageSetSize;    //* Total PageSet Size
            CurrPageSet = 1;                                        //* Current PageSet
            LastPage = TotRecs / PageSize;                          //* Last Page
            LastPageRecs = TotRecs % PageSize;                      //* Records on Last Page
        }

        this.removeAll();   //* Remove all the Component otherwise it will show 2 lines of all the components

        /**
         * if LastPageRecs > 0 then set LastPage += 1..
         */
        if(LastPageRecs > 0)
        {
            LastPage = (TotRecs / PageSize) + 1;
        }

        setOpaque(true);
        Insets m = new Insets(2,2,2,2);
        Dimension d = new Dimension(35,25);
//        Font f = new Font("Tahoma",Font.BOLD,10);

        /**
         * if PageSetSize <= 8 (i.e. 3-VCRPrev, 3-VCRNext, 2-Labels for displaying the Current Page/Total Pages),
         * then if PageSetSize = 0 then Set the Grid Layout with 1 Row, otherwise Set it with 2 Rows & then 
         * Create the required Numbered Buttons & also add some Blank Labels after them to make the 1st Row total to 8..
         */
        if(PageSetSize <= 8)
        {
            if(PageSetSize == 0)
            {
                setLayout(new GridLayout(1,8));
            }
            else
            {
                setLayout(new GridLayout(2,8));

                BtnNums = new JButton[PageSetSize];

                for(int i = 0; i < PageSetSize; i++)
                {
                    BtnNums[i] = new JButton(String.valueOf(i + 1));
                    BtnNums[i].setMargin(m);
                    BtnNums[i].setPreferredSize(d);
                    BtnNums[i].setMaximumSize(d);
                    BtnNums[i].addActionListener(this);
//                    BtnNums[i].setFont(f);

                    add(BtnNums[i]);
                }

                lblBlank = new JLabel[8 - PageSetSize];

                for(int i = 0; i < (8 - PageSetSize); i++)
                {
                    lblBlank[i] = new JLabel();
                    lblBlank[i].setPreferredSize(d);
                    lblBlank[i].setMaximumSize(d);

                    add(lblBlank[i]);
                }
            }
        }
        /**
         * if PageSetSize > 8 then Set the Grid Layout with 2 Rows & Columns = PageSetSize
         * & according to that create the Numnbered Buttons..
         */
        else if(PageSetSize > 8)
        {
            setLayout(new GridLayout(2,PageSetSize));
            BtnNums = new JButton[PageSetSize];
            for(int i = 0; i < PageSetSize; i++)
            {
                BtnNums[i] = new JButton(String.valueOf(i + 1));
                BtnNums[i].setMargin(m);
                BtnNums[i].setPreferredSize(d);
                BtnNums[i].setMaximumSize(d);
                BtnNums[i].addActionListener(this);
//                BtnNums[i].setFont(f);

                add(BtnNums[i]);
            }
        }

        /**
         * Create 3 VCRPrev & 3 VCRNext Buttons along with 2 Labels for displaying Current Page / Total Pages..
         */
        btnFirst = new JButton();
        btnFirst.setText("|<");
        btnFirst.setMargin(m);
        btnFirst.setPreferredSize(d);
        btnFirst.setMaximumSize(d);
        btnFirst.addActionListener(this);
        clrNormal = btnFirst.getBackground();
        btnLast = new JButton();
        btnLast.setText(">|");
        btnLast.setMargin(m);
        btnLast.setPreferredSize(d);
        btnLast.setMaximumSize(d);
        btnLast.addActionListener(this);
        btnPrevSet = new JButton();
        btnPrevSet.setText("<<");
        btnPrevSet.setMargin(m);
        btnPrevSet.setPreferredSize(d);
        btnPrevSet.setMaximumSize(d);
        btnPrevSet.addActionListener(this);
        btnNextSet = new JButton();
        btnNextSet.setText(">>");
        btnNextSet.setMargin(m);
        btnNextSet.setPreferredSize(d);
        btnNextSet.setMaximumSize(d);
        btnNextSet.addActionListener(this);
        btnPrev = new JButton();
        btnPrev.setText("<");
        btnPrev.setMargin(m);
        btnPrev.setPreferredSize(d);
        btnPrev.setMaximumSize(d);
        btnPrev.addActionListener(this);
        btnNext = new JButton();
        btnNext.setText(">");
        btnNext.setMargin(m);
        btnNext.setPreferredSize(d);
        btnNext.setMaximumSize(d);
        btnNext.addActionListener(this);
        lblCurrPage = new JLabel();
        lblCurrPage.setPreferredSize(d);
        lblCurrPage.setMaximumSize(d);
        lblCurrPage.setHorizontalAlignment(JLabel.RIGHT);
        lblTotPage = new JLabel();
        lblTotPage.setText(String.valueOf("/" + LastPage));
        lblTotPage.setPreferredSize(d);
        lblTotPage.setMaximumSize(d);
        lblTotPage.setHorizontalAlignment(JLabel.LEFT);

        add(btnFirst);
        add(btnPrevSet);
        add(btnPrev);
        add(lblCurrPage);
        add(lblTotPage);
        add(btnNext);
        add(btnNextSet);
        add(btnLast);

        /**
         * if PageSetSize > 8 then add required Blank Labels at 2nd Row after VCR Button
         * to make the 2nd Row total to PageSetSize..
         */
        if(PageSetSize > 8)
        {
            lblBlank = new JLabel[PageSetSize - 8];
            for(int i = 0; i < (PageSetSize - 8); i++)
            {
                lblBlank[i] = new JLabel();
                lblBlank[i].setPreferredSize(d);
                lblBlank[i].setMaximumSize(d);

                add(lblBlank[i]);
            }
        }

        validate();
        setVisible(true);
    }

    /**
     * Get the Page Size..
     * @return
     */
    public int getPageSize()
    {
        return this.PageSize;
    }

    /**
     * Set the Page Size..
     * @param ps
     */
    public void setPageSize(int ps)
    {
        this.PageSize = ps;
    }

    /**
     * Get the PageSet Size (Numbered Buttons)..
     * @return
     */
    public int getPageSetSize()
    {
        return this.PageSetSize;
    }

    /**
     * Set the PageSet Size (Numbered Buttons)..
     * @param pss
     */
    public void setPageSetSize(int pss)
    {
        this.PageSetSize = pss;
    }

    /**
     * get the no. of Total Records..
     * @return
     */
    public int getTotRecs()
    {
        return this.TotRecs;
    }

    /**
     * Set the Total no. of Records..
     * @param tr
     */
    public void setTotRecs(int tr)
    {
        this.TotRecs = tr;
    }

    /**
     * Get the Records to Display..
     * @return
     */
    public int[] getRecs()
    {
        return this.Recs;
    }

    /**
     * Set how much Records to Display..
     * @param r
     */
    private void setRecs(int[] r)
    {
        this.Recs = r;
    }

    /**
     * Set the Visibility of VCRNext Buttons..
     * @param value
     */
    private void VCRNext(boolean value)
    {
        btnLast.setVisible(value);
        btnNextSet.setVisible(value);
        btnNext.setVisible(value);
    }

    /**
     * Set the Visibility of VCRPrev Buttons..
     * @param value
     */
    private void VCRPrev(boolean value)
    {
        btnFirst.setVisible(value);
        btnPrevSet.setVisible(value);
        btnPrev.setVisible(value);
    }

    /**
     * Set the Color of the Button (Current/Normal)..
     */
    public void SetBtnColor()
    {
        JButton jb;
        for(int i = 0; i < PageSetSize; i++)
        {
            jb = (JButton)BtnNums[i];
            jb.setBackground(clrNormal);
            if(jb.getText().equals(String.valueOf(CurrPage)))
            {
                jb.setBackground(Color.PINK);
            }
        }
    }

    /**
     * Set the Start & Stop Rec & according to that Create the Array of Records to Display..
     * @param PageNumber
     * @return
     */
    private int[] GoToPage(int PageNumber)
    {
        int Index = 0;
        int startRec = (PageSize * (PageNumber - 1)) + 1;
        int stopRec = 0;

        if(PageNumber > (TotRecs / PageSize))
        {
            stopRec = (PageSize * (PageNumber - 1)) + LastPageRecs;
        }
        else
        {
            stopRec = (PageSize * (PageNumber - 1)) + PageSize;
        }

        Recs = new int[PageSize];
        /** Add Records to TextArea depending on the Page Size */
        for(int no = startRec; no <= stopRec; no++)
        {
            Recs[Index] = no;
            Index++;
        }

        SetBtnColor();

        return Recs;
    }

    /**
     * Set the Text of the Numbered Buttons according to the Current PageSetSize..
     * @param PageSet
     */
    private void SetPageBtns(int PageSet)
    {
        JButton jb;

        if(CurrPageSet == (TotPageSetSize + 1))
        {
            for(int i = 0; i < PageSetSize; i++)
            {
                jb = (JButton)BtnNums[i];
                jb.setText(String.valueOf((PageSet * PageSetSize - PageSetSize) + i + 1));
                if(((PageSet * PageSetSize - PageSetSize) + i + 1) > LastPage)
                {
                    jb.setVisible(false);
                }
                else
                {
                    jb.setVisible(true);
                }
            }
        }
        else
        {
            for(int i = 0; i <
                PageSetSize; i++)
            {
                jb = (JButton)BtnNums[i];
                jb.setText(String.valueOf((PageSet * PageSetSize - PageSetSize) + i + 1));
                jb.setVisible(true);
            }

        }
    }

    /**
     * Check the Page Size whether it is within the given Range or not..
     * @param PageSize
     * @return
     */
    private boolean CheckPageSize(int PageSize)
    {
        if(PageSize > 50)
        {
            JOptionPane.showMessageDialog(null,"You must Enter Page Size <= 50","Enter Valid Page Size",0);
            return false;
        }
        else
        {
            return true;
        }
    }

    /**
     * 
     * @param strCurr
     */
    private void Navigate(String strCurr)
    {
        TotPageSetSize = (TotRecs / PageSize) / PageSetSize;

        boolean blnStatus;      //* Whether PageSize is acceptable or not
        blnStatus = CheckPageSize(PageSize);

        if(!blnStatus)      //* if PageSize is not acceptable, exit the function
        {
            return;
        }

        LastPage = TotRecs / PageSize;             //* Last Page Number
        LastPageRecs = TotRecs % PageSize;         //* No. of Records on Last Page

        if(strCurr.equals("|<"))
        {
            VCRNext(true);
            /** if btnFirstPage is Visible, only then display Records */
            if(btnFirst.isVisible())
            {
                CurrPage = 1;
                CurrPageSet = 1;
                SetPageBtns(CurrPageSet);
                setRecs(GoToPage(1));
            }

            VCRPrev(false);
        }
        else if(strCurr.equals("<"))
        {
            VCRNext(true);
            btnPrevSet.setVisible(true);
            btnFirst.setVisible(true);

            CurrPage -= 1;

            if(CurrPage <= ((CurrPageSet - 1) * PageSetSize))
            {
                CurrPageSet -= 1;
                SetPageBtns(CurrPageSet);
            }

            if(CurrPage == 1)
            {
                VCRPrev(false);
                setRecs(GoToPage(CurrPage));
            }

            if(btnPrev.isVisible())
            {
                setRecs(GoToPage(CurrPage));
            }

        }
        else if(strCurr.equals("<<"))
        {
            VCRNext(true);
            btnPrev.setVisible(true);
            btnFirst.setVisible(true);

            CurrPage -= PageSetSize;
            CurrPageSet -= 1;

            if(CurrPageSet < 1)
            {
                CurrPageSet = 1;
            }

            SetPageBtns(CurrPageSet);

            if(CurrPage < 1)
            {
                CurrPage = 1;
                CurrPageSet = 1;
            }

            /** if CurrPage = 1, make Prev VCR Buttons Invisible */
            if(CurrPage == 1)
            {
                VCRPrev(false);
                setRecs(GoToPage(CurrPage));
            }

            if(btnPrevSet.isVisible())
            {
                setRecs(GoToPage(CurrPage));
            }

        }
        else if(strCurr.equals(">"))
        {
            btnLast.setVisible(true);
            btnNextSet.setVisible(true);

            VCRPrev(true);

            CurrPage += 1;

            if(LastPageRecs > 0)
            {
                LastPage = (TotRecs / PageSize) + 1;
            }

            if(CurrPage > LastPage)
            {
                CurrPage = LastPage;
                CurrPageSet = LastPage / PageSetSize + 1;
            }

            if(CurrPage > (CurrPageSet * PageSetSize))
            {
                CurrPageSet += 1;
                SetPageBtns(CurrPageSet);
            }

            if(CurrPage == LastPage)
            {
                VCRNext(false);
                setRecs(GoToPage(CurrPage));
            }

            if(btnNext.isVisible())
            {
                setRecs(GoToPage(CurrPage));
            }

        }
        else if(strCurr.equals(">>"))
        {
            btnLast.setVisible(true);
            btnNext.setVisible(true);

            VCRPrev(true);

            CurrPage += PageSetSize;
            CurrPageSet += 1;

            if(LastPageRecs > 0)
            {
                LastPage = (TotRecs / PageSize) + 1;
            }

            if(CurrPage > LastPage)
            {
                CurrPage = LastPage;
                CurrPageSet = LastPage / PageSetSize + 1;
            }

            SetPageBtns(CurrPageSet);
            /** if CurrPage = LastPage, make Next VCR Buttons Invisible */
            if(CurrPage == LastPage)
            {
                VCRNext(false);
                setRecs(GoToPage(CurrPage));
            }

            if(btnNextSet.isVisible())
            {
                setRecs(GoToPage(CurrPage));
            }

        }
        else if(strCurr.equals(">|"))
        {
            VCRPrev(true);

            if(btnLast.isVisible())
            {
                CurrPageSet = LastPage / PageSetSize;     //* Current Page Set
                if(LastPageRecs > 0)
                {
                    LastPage = (TotRecs / PageSize) + 1;
                    CurrPageSet = LastPage / PageSetSize + 1;
                }

                SetPageBtns(CurrPageSet);
                CurrPage = LastPage;
//                Integer.parseInt(strCurrNumBtn);
                setRecs(GoToPage(CurrPage));
            }

            VCRNext(false);

        }
        else
        {
            CurrPage = Integer.parseInt(strCurr);
            setRecs(GoToPage(CurrPage));
        }

    }

    private void PrintRecs()
    {
        for(int i = 0; i < PageSize; i++)
        {
            System.out.println(Recs[i]);
        }

    }

    public void actionPerformed(ActionEvent e)
    {
        JButton btnCurr = (JButton)e.getSource();
        String strCurr = btnCurr.getText();
        Navigate(strCurr);
        lblCurrPage.setText(String.valueOf(CurrPage));
        PrintRecs();
    }

    public void propertyChange(PropertyChangeEvent evt)
    {
//        new PaginateComponent();
        RefreshPaginate();
        lblCurrPage.setText(String.valueOf(CurrPage));
    }

}
