/*
 * Decompiled with CFR 0.152.
 */
package ticker;

import java.awt.Graphics;
import ticker.Ticker;

class LEDRenderer
implements Runnable {
    private Ticker applet;
    private boolean exitNow = false;
    private int frameNumber = 0;

    LEDRenderer(Ticker ticker) {
        this.applet = ticker;
    }

    public void run() {
        while (!this.exitNow) {
            ++this.frameNumber;
            this.applet.repaint();
            try {
                Thread.sleep(this.applet.movementIntervalms);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void stop() {
        this.exitNow = true;
    }

    synchronized void render(Graphics g) {
        int columnOffset = 0;
        int availWidth = this.applet.getWidth();
        int groupDim = this.applet.numDotsGroup * this.applet.dotCenterOffset / 5;
        int realColumns = availWidth / groupDim;
        int offset = (this.applet.getHeight() - (5 * groupDim + (this.applet.numDotsGroup - 1) * this.applet.dotCenterOffset / 5 + this.applet.dotDiameter / 5)) / 2;
        for (int i = 0; i < realColumns; ++i) {
            char[] currentCol = new char[6];
            for (int j = 0; j < 6; ++j) {
                currentCol[j] = this.applet.ledString[j].charAt((this.frameNumber + i) % this.applet.ledString[0].length());
            }
            this.drawColumn(g, i, currentCol, columnOffset, groupDim, offset);
        }
    }

    void drawColumn(Graphics g, int column, char[] coldata, int columnOffset, int groupDim, int offset) {
        int columnOriginX = column * groupDim;
        for (int rowCounter = 0; rowCounter < 6; ++rowCounter) {
            g.setColor(this.applet.dotOffColor);
            if (coldata[rowCounter] == 'X') {
                g.setColor(this.applet.dotOnColor);
            }
            int originY = rowCounter * groupDim + offset;
            int diameter = this.applet.dotDiameter / 5;
            for (int x = 0; x < this.applet.numDotsGroup; ++x) {
                for (int y = 0; y < this.applet.numDotsGroup; ++y) {
                    if (this.applet.squareLeds) {
                        g.fillRect(columnOriginX + x * this.applet.dotCenterOffset / 5 - columnOffset, originY + y * this.applet.dotCenterOffset / 5, diameter, diameter);
                        continue;
                    }
                    g.fillOval(columnOriginX + x * this.applet.dotCenterOffset / 5 - columnOffset, originY + y * this.applet.dotCenterOffset / 5, diameter, diameter);
                }
            }
        }
    }
}

