/*
 * Decompiled with CFR 0.152.
 */
package ticker;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.DesignMode;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import ticker.Chars;
import ticker.LEDRenderer;

public class Ticker
extends JComponent
implements DesignMode {
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    LEDRenderer renderer = null;
    String inputString = new String("YOU FORGOT TO SPECIFY A LABEL! ");
    String[] ledString;
    boolean squareLeds = false;
    int movementIntervalms = 40;
    int dotDiameter = 35;
    int numDotsGroup = 1;
    int dotCenterOffset = 40;
    Color dotOnColor = Color.blue;
    Color dotOffColor = Color.yellow;
    private boolean designTime;

    public boolean getSquaredLeds() {
        return this.squareLeds;
    }

    public void setSquaredLeds(boolean squareLeds) {
        this.squareLeds = squareLeds;
        this.changeSupport.firePropertyChange("squareLeds", null, null);
    }

    public String getLabel() {
        return this.inputString;
    }

    public void setLabel(String label) {
        this.inputString = label.toUpperCase() + " ";
        this.ledString = this.assembleString(this.inputString);
        this.changeSupport.firePropertyChange("label", null, null);
    }

    public int getLedDiameter() {
        return this.dotDiameter;
    }

    public void setLedDiameter(int dotDiameter) {
        this.dotDiameter = dotDiameter;
        if (dotDiameter > this.dotCenterOffset) {
            this.setLedDistance(dotDiameter);
        }
        this.changeSupport.firePropertyChange("ledDiameter", null, null);
    }

    public int getGroupSize() {
        return this.numDotsGroup;
    }

    public void setGroupSize(int numDotsGroup) {
        this.numDotsGroup = numDotsGroup;
        this.changeSupport.firePropertyChange("groupSize", null, null);
    }

    public int getLedDistance() {
        return this.dotCenterOffset;
    }

    public void setLedDistance(int dotCenterOffset) {
        this.dotCenterOffset = dotCenterOffset;
        if (dotCenterOffset < this.dotDiameter) {
            this.setLedDiameter(dotCenterOffset);
        }
        this.changeSupport.firePropertyChange("ledDistance", null, null);
    }

    public int getSpeed() {
        return 120 - this.movementIntervalms;
    }

    public void setSpeed(int speed) {
        this.movementIntervalms = 120 - speed;
        this.changeSupport.firePropertyChange("speed", null, null);
    }

    public Color getOnColor() {
        return this.dotOnColor;
    }

    public void setOnColor(Color onColor) {
        this.dotOnColor = onColor;
        this.changeSupport.firePropertyChange("onColor", null, null);
    }

    public Color getOffColor() {
        return this.dotOffColor;
    }

    public void setOffColor(Color offColor) {
        this.dotOffColor = offColor;
        this.changeSupport.firePropertyChange("offColor", null, null);
    }

    public Ticker() {
        this.ledString = this.assembleString(this.inputString);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.renderer.render(g);
    }

    private String[] assembleString(String plain) {
        String[] output = new String[6];
        String interCharacterGapString = new String(" ");
        for (int i = 0; i < 6; ++i) {
            StringBuffer temp = new StringBuffer();
            block55: for (int j = 0; j < plain.length(); ++j) {
                char currentPlainChar = plain.charAt(j);
                switch (currentPlainChar) {
                    case 'A': {
                        temp.append(Chars.A[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'B': {
                        temp.append(Chars.B[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'C': {
                        temp.append(Chars.C[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'D': {
                        temp.append(Chars.D[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'E': {
                        temp.append(Chars.E[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'F': {
                        temp.append(Chars.F[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'G': {
                        temp.append(Chars.G[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'H': {
                        temp.append(Chars.H[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'I': {
                        temp.append(Chars.I[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'J': {
                        temp.append(Chars.J[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'K': {
                        temp.append(Chars.K[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'L': {
                        temp.append(Chars.L[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'M': {
                        temp.append(Chars.M[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'N': {
                        temp.append(Chars.N[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'O': {
                        temp.append(Chars.O[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'P': {
                        temp.append(Chars.P[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'Q': {
                        temp.append(Chars.Q[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'R': {
                        temp.append(Chars.R[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'S': {
                        temp.append(Chars.S[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'T': {
                        temp.append(Chars.T[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'U': {
                        temp.append(Chars.U[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'V': {
                        temp.append(Chars.V[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'W': {
                        temp.append(Chars.W[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'X': {
                        temp.append(Chars.X[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'Y': {
                        temp.append(Chars.Y[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case 'Z': {
                        temp.append(Chars.Z[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case ' ': {
                        temp.append(Chars.space[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '.': {
                        temp.append(Chars.fullstop[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case ',': {
                        temp.append(Chars.comma[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '\'': {
                        temp.append(Chars.apostrophe[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '?': {
                        temp.append(Chars.question[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '!': {
                        temp.append(Chars.exclamation[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '-': {
                        temp.append(Chars.dash[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '/': {
                        temp.append(Chars.slashUp[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '\\': {
                        temp.append(Chars.slashDown[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '_': {
                        temp.append(Chars.underscore[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '@': {
                        temp.append(Chars.at[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '$': {
                        temp.append(Chars.dollar[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '#': {
                        temp.append(Chars.hash[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '(': {
                        temp.append(Chars.openParen[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case ')': {
                        temp.append(Chars.closeParen[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case ':': {
                        temp.append(Chars.colon[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '0': {
                        temp.append(Chars.zero[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '1': {
                        temp.append(Chars.one[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '2': {
                        temp.append(Chars.two[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '3': {
                        temp.append(Chars.three[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '4': {
                        temp.append(Chars.four[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '5': {
                        temp.append(Chars.five[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '6': {
                        temp.append(Chars.six[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '7': {
                        temp.append(Chars.seven[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '8': {
                        temp.append(Chars.eight[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    case '9': {
                        temp.append(Chars.nine[i]);
                        temp.append(interCharacterGapString);
                        continue block55;
                    }
                    default: {
                        System.err.println("Character not available: " + currentPlainChar);
                    }
                }
            }
            output[i] = new String(temp);
        }
        return output;
    }

    private void startRenderer() {
        this.renderer = new LEDRenderer(this);
        if (!this.isDesignTime()) {
            new Thread(this.renderer).start();
        }
    }

    private void stopRenderer() {
        this.renderer.stop();
    }

    public void addNotify() {
        super.addNotify();
        this.startRenderer();
    }

    public void removeNotify() {
        super.removeNotify();
        this.stopRenderer();
    }

    public void setDesignTime(boolean designTime) {
        this.designTime = designTime;
    }

    public boolean isDesignTime() {
        return this.designTime;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

