/*
 * Decompiled with CFR 0.152.
 */
package com.actiwaves.swing.TestSwing;

import com.actiwaves.swing.TestSwing.TestSwingAboutBox;
import com.actiwaves.swing.TestSwing.TestSwingApp;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;

public class TestSwingView
extends FrameView {
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public TestSwingView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestSwingView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestSwingView.this.busyIconIndex = (TestSwingView.this.busyIconIndex + 1) % TestSwingView.this.busyIcons.length;
                TestSwingView.this.statusAnimationLabel.setIcon(TestSwingView.this.busyIcons[TestSwingView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!TestSwingView.this.busyIconTimer.isRunning()) {
                        TestSwingView.this.statusAnimationLabel.setIcon(TestSwingView.this.busyIcons[0]);
                        TestSwingView.this.busyIconIndex = 0;
                        TestSwingView.this.busyIconTimer.start();
                    }
                    TestSwingView.this.progressBar.setVisible(true);
                    TestSwingView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    TestSwingView.this.busyIconTimer.stop();
                    TestSwingView.this.statusAnimationLabel.setIcon(TestSwingView.this.idleIcon);
                    TestSwingView.this.progressBar.setVisible(false);
                    TestSwingView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    TestSwingView.this.statusMessageLabel.setText(text == null ? "" : text);
                    TestSwingView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    TestSwingView.this.progressBar.setVisible(true);
                    TestSwingView.this.progressBar.setIndeterminate(false);
                    TestSwingView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = TestSwingApp.getApplication().getMainFrame();
            this.aboutBox = new TestSwingAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        TestSwingApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(0, 252, Short.MAX_VALUE));
        this.menuBar.setName("menuBar");
        ResourceMap resourceMap = Application.getInstance(TestSwingApp.class).getContext().getResourceMap(TestSwingView.class);
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(TestSwingApp.class).getContext().getActionMap(TestSwingView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)statusPanelLayout);
        statusPanelLayout.setHorizontalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((Component)statusPanelSeparator, -1, 400, Short.MAX_VALUE).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.statusMessageLabel).addPreferredGap(0, 226, Short.MAX_VALUE).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0).add((Component)this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((Component)statusPanelSeparator, -2, 2, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)statusPanelLayout.createParallelGroup(3).add((Component)this.statusMessageLabel).add((Component)this.statusAnimationLabel).add((Component)this.progressBar, -2, -1, -2)).add(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }
}

