/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.actiwaves.swing.TestSwing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

/**
 *
 * @author sudeep.panchal
 */
@Entity
@Table(name = "persons")
@NamedQueries( {@NamedQuery(name = "Persons.findByFirstName",query = "SELECT p FROM Persons p WHERE p.firstName = :firstName"),@NamedQuery(name = "Persons.findByMiddleName",query = "SELECT p FROM Persons p WHERE p.middleName = :middleName"),@NamedQuery(name = "Persons.findByLastName",query = "SELECT p FROM Persons p WHERE p.lastName = :lastName"),@NamedQuery(name = "Persons.findBySex",query = "SELECT p FROM Persons p WHERE p.sex = :sex"),@NamedQuery(name = "Persons.findByBirthDate",query = "SELECT p FROM Persons p WHERE p.birthDate = :birthDate"),@NamedQuery(name = "Persons.findByContactID",query = "SELECT p FROM Persons p WHERE p.contactID = :contactID"),@NamedQuery(name = "Persons.findByMetaID",query = "SELECT p FROM Persons p WHERE p.metaID = :metaID")})
public class Persons implements Serializable {
    @Transient
    private
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final
    long serialVersionUID = 1L;
    @Column(name = "FirstName",nullable = false)
    private
    String firstName;
    @Column(name = "MiddleName",nullable = false)
    private
    String middleName;
    @Column(name = "LastName",nullable = false)
    private
    String lastName;
    @Column(name = "Sex")
    private
    String sex;
    @Column(name = "BirthDate",nullable = false)
    @Temporal(TemporalType.DATE)
    private
    Date birthDate;
    @Column(name = "ContactID",nullable = false)
    private
    long contactID;
    @Id
    @Column(name = "MetaID",nullable = false)
    private
    Long metaID;

    public
    Persons()
    {
    }

    public
    Persons(Long metaID)
    {
        this.metaID = metaID;
    }

    public
    Persons(Long metaID,String firstName,String middleName,String lastName,Date birthDate,long contactID)
    {
        this.metaID = metaID;
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.birthDate = birthDate;
        this.contactID = contactID;
    }

    public
    String getFirstName()
    {
        return firstName;
    }

    public
    void setFirstName(String firstName)
    {
        String oldFirstName = this.firstName;
        this.firstName = firstName;
        changeSupport.firePropertyChange("firstName",oldFirstName,firstName);
    }

    public
    String getMiddleName()
    {
        return middleName;
    }

    public
    void setMiddleName(String middleName)
    {
        String oldMiddleName = this.middleName;
        this.middleName = middleName;
        changeSupport.firePropertyChange("middleName",oldMiddleName,middleName);
    }

    public
    String getLastName()
    {
        return lastName;
    }

    public
    void setLastName(String lastName)
    {
        String oldLastName = this.lastName;
        this.lastName = lastName;
        changeSupport.firePropertyChange("lastName",oldLastName,lastName);
    }

    public
    String getSex()
    {
        return sex;
    }

    public
    void setSex(String sex)
    {
        String oldSex = this.sex;
        this.sex = sex;
        changeSupport.firePropertyChange("sex",oldSex,sex);
    }

    public
    Date getBirthDate()
    {
        return birthDate;
    }

    public
    void setBirthDate(Date birthDate)
    {
        Date oldBirthDate = this.birthDate;
        this.birthDate = birthDate;
        changeSupport.firePropertyChange("birthDate",oldBirthDate,birthDate);
    }

    public
    long getContactID()
    {
        return contactID;
    }

    public
    void setContactID(long contactID)
    {
        long oldContactID = this.contactID;
        this.contactID = contactID;
        changeSupport.firePropertyChange("contactID",oldContactID,contactID);
    }

    public
    Long getMetaID()
    {
        return metaID;
    }

    public
    void setMetaID(Long metaID)
    {
        Long oldMetaID = this.metaID;
        this.metaID = metaID;
        changeSupport.firePropertyChange("metaID",oldMetaID,metaID);
    }

    @Override
    public
    int hashCode()
    {
        int hash = 0;
        hash += (metaID != null ? metaID.hashCode() : 0);
        return hash;
    }

    @Override
    public
    boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if(!(object instanceof Persons))
        {
            return false;
        }
        Persons other = (Persons)object;
        if((this.metaID == null && other.metaID != null) || (this.metaID != null && !this.metaID.equals(other.metaID)))
        {
            return false;
        }
        return true;
    }

    @Override
    public
    String toString()
    {
        return "com.actiwaves.swing.TestSwing.Persons[metaID=" + metaID + "]";
    }

    public
    void addPropertyChangeListener(PropertyChangeListener listener)
    {
        changeSupport.addPropertyChangeListener(listener);
    }

    public
    void removePropertyChangeListener(PropertyChangeListener listener)
    {
        changeSupport.addPropertyChangeListener(listener);
    }

}
