/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.actiwaves.swing.TestSwing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 *
 * @author sudeep.panchal
 */
@Entity
@Table(name = "states")
@NamedQueries( {@NamedQuery(name = "States.findByStateID",query = "SELECT s FROM States s WHERE s.stateID = :stateID"),@NamedQuery(name = "States.findByStateName",query = "SELECT s FROM States s WHERE s.stateName = :stateName"),@NamedQuery(name = "States.findByCountryCode",query = "SELECT s FROM States s WHERE s.countryCode = :countryCode")})
public class States implements Serializable {
    @Transient
    private
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final
    long serialVersionUID = 1L;
    @Id
    @Column(name = "StateID",nullable = false)
    private
    Short stateID;
    @Column(name = "StateName",nullable = false)
    private
    String stateName;
    @Column(name = "CountryCode",nullable = false)
    private
    short countryCode;

    public
    States()
    {
    }

    public
    States(Short stateID)
    {
        this.stateID = stateID;
    }

    public
    States(Short stateID,String stateName,short countryCode)
    {
        this.stateID = stateID;
        this.stateName = stateName;
        this.countryCode = countryCode;
    }

    public
    Short getStateID()
    {
        return stateID;
    }

    public
    void setStateID(Short stateID)
    {
        Short oldStateID = this.stateID;
        this.stateID = stateID;
        changeSupport.firePropertyChange("stateID",oldStateID,stateID);
    }

    public
    String getStateName()
    {
        return stateName;
    }

    public
    void setStateName(String stateName)
    {
        String oldStateName = this.stateName;
        this.stateName = stateName;
        changeSupport.firePropertyChange("stateName",oldStateName,stateName);
    }

    public
    short getCountryCode()
    {
        return countryCode;
    }

    public
    void setCountryCode(short countryCode)
    {
        short oldCountryCode = this.countryCode;
        this.countryCode = countryCode;
        changeSupport.firePropertyChange("countryCode",oldCountryCode,countryCode);
    }

    @Override
    public
    int hashCode()
    {
        int hash = 0;
        hash += (stateID != null ? stateID.hashCode() : 0);
        return hash;
    }

    @Override
    public
    boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if(!(object instanceof States))
        {
            return false;
        }
        States other = (States)object;
        if((this.stateID == null && other.stateID != null) || (this.stateID != null && !this.stateID.equals(other.stateID)))
        {
            return false;
        }
        return true;
    }

    @Override
    public
    String toString()
    {
        return "com.actiwaves.swing.TestSwing.States[stateID=" + stateID + "]";
    }

    public
    void addPropertyChangeListener(PropertyChangeListener listener)
    {
        changeSupport.addPropertyChangeListener(listener);
    }

    public
    void removePropertyChangeListener(PropertyChangeListener listener)
    {
        changeSupport.addPropertyChangeListener(listener);
    }

}
